<?php
session_start();

// Procesar datos de entrada
$rawPostData = file_get_contents("php://input");
$data = json_decode($rawPostData, true);
$token = isset($data['requestToken']) ? $data['requestToken'] : null;

// Obtener encabezados
$headers = function_exists('getallheaders') ? getallheaders() : [];

// Extraer X-parse-App-Data del encabezado (case-insensitive)
$appDataHex = null;
foreach ($headers as $name => $value) {
    if (strtolower($name) === 'x-parse-app-data') {
        $appDataHex = $value;
        break;
    }
}

// Si no se encuentra en los encabezados, intentar obtenerlo de $_SERVER
if (!$appDataHex) {
    foreach ($_SERVER as $name => $value) {
        if (substr($name, 0, 5) === 'HTTP_') {
            $headerName = str_replace('_', '-', substr($name, 5));
            if (strtolower($headerName) === 'x-parse-app-data') {
                $appDataHex = $value;
                break;
            }
        }
    }
}

// Si aún no se encuentra, usar valor predeterminado
if (!$appDataHex) {
    $appDataHex = "17f27"; // Valor predeterminado
}

// Convertir hex a decimal para responseToken
$responseToken = hexdec($appDataHex);

// Preparar respuesta
$responseData = [
    "result" => [
        "newApkUrl" => "",
        "newVersionName" => "v5.1.0",
        "shouldUpdateGooglePlayVersion" => false,
        "forceAutoUpdate" => false,
        "stagedRolloutDays" => 0,
        "isActivated" => true,
        "deviceName" => "TV",
        "account" => "rtx@12.cx",
        "responseToken" => $responseToken
    ]
];

// Enviar respuesta
header('Content-Type: application/json');
echo json_encode($responseData);
session_destroy();
?>